/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.ccfw.service.bpa;

import com.ibm.hsc.cim.client.pi.PIHSCFrameCIMClient;
import com.ibm.hwmca.fw.service.managedsystem.ServiceableElementMaintenanceException;
import com.ibm.hwmca.fw.service.panel.GenericGui;
import com.ibm.hwmca.fw.service.panel.GenericGuiPanelBean;
import com.ibm.hwmca.fw.service.panel.ResultsAnd3ButtonGroupDataBean;
import com.ibm.hwmca.fw.service.statetransition.Context;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.service.PETrace;
import com.ibm.hwmca.xfw.service.SD;
import com.ibm.hwmca.xfw.service.managedsystem.DefaultServiceableElementMaintenance;
import com.ibm.hwmca.xfw.service.managedsystem.fru.BpaResidentFru;
import java.util.Hashtable;
import java.util.Map;

public class PIBpaConcurrentMaintenance
extends DefaultServiceableElementMaintenance {
    private static final String TRACE_MASKT = "XRVBPCMT";
    private static final String TRACE_MASKF = "XRVBPCMF";
    private static final String TRACE_MASKD = "XRVBPCMD";
    private static int SET_LOCK = 0;
    private static int CLEAR_LOCK = 1;
    private static int QUERY_LOCK = 2;
    private static int RESET_LOCK = 3;
    private PIHSCFrameCIMClient cimClient_ = null;
    private boolean lockMayHaveBeenObtained = false;

    public PIBpaConcurrentMaintenance(String string, String string2, boolean bl, String string3) throws ServiceableElementMaintenanceException {
        Trace.trace((String)TRACE_MASKT, (Object)("-> PIBpaConcurrentMaintenance ctor, hostName[" + string + "],frameName[" + string2 + "],isIntName[" + bl + "],nameSpace[" + string3 + "]"));
        try {
            PETrace.petrace((Map)this.userData, (String)("creating BPA hardware interface to frame name: " + string2));
            this.showBusy(new LocalizableText("Setting up connection to " + string2));
            this.cimClient_ = PIHSCFrameCIMClient.createInstance(string, string2, bl, string3);
        }
        catch (Exception exception) {
            PETrace.petrace((Map)this.userData, (String)("exception caught creating BPA hardware interface: " + exception));
            PETrace.petrace((Map)this.userData, (Throwable)exception);
            Trace.trace((String)TRACE_MASKF, (Object)("<-! PIBpaConcurrentMaintenance ctor, exception caught: " + exception));
            Trace.trace((String)TRACE_MASKF, (Object)exception);
            throw new ServiceableElementMaintenanceException((Throwable)exception);
        }
        finally {
            this.destroyBusy();
        }
        if (this.cimClient_ == null) {
            PETrace.petrace((Map)this.userData, (String)"unable to establish BPA connection - null handle returned");
            Trace.trace((String)TRACE_MASKT, (Object)"<-! PIBpaConcurrentMaintenance ctor, PIHSCFrameCIMClient.createInstance returned null");
            throw new ServiceableElementMaintenanceException("PIHSCFrameCIMClient.createInstance returned null");
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- PIBpaConcurrentMaintenance ctor, cimClient handle created: " + this.cimClient_));
    }

    private boolean displayLockFailure(String string) {
        ResultsAnd3ButtonGroupDataBean resultsAnd3ButtonGroupDataBean = this.beanSetup(string);
        resultsAnd3ButtonGroupDataBean.disableControl("RadioButton1");
        return this.displayError(resultsAnd3ButtonGroupDataBean);
    }

    private boolean displayOtherFailure(String string) {
        ResultsAnd3ButtonGroupDataBean resultsAnd3ButtonGroupDataBean = this.beanSetup(string);
        return this.displayError(resultsAnd3ButtonGroupDataBean);
    }

    private ResultsAnd3ButtonGroupDataBean beanSetup(String string) {
        String string2;
        ResultsAnd3ButtonGroupDataBean resultsAnd3ButtonGroupDataBean = new ResultsAnd3ButtonGroupDataBean();
        resultsAnd3ButtonGroupDataBean.setButtongroupTitle("Select:");
        resultsAnd3ButtonGroupDataBean.setRadioButton1Title("Proceed");
        resultsAnd3ButtonGroupDataBean.setRadioButton2Title("Retry the operation");
        resultsAnd3ButtonGroupDataBean.setRadioButton3Title("Delay service action");
        resultsAnd3ButtonGroupDataBean.setButtongroupSelection(new String[]{"RadioButton2"});
        resultsAnd3ButtonGroupDataBean.hideCancelButton();
        String string3 = (String)this.serviceableElement.getProperty((Object)"LOCATION");
        if (string3 == null) {
            string3 = "unknown";
        }
        if ((string2 = (String)this.serviceableElement.getProperty((Object)"DESC")) == null) {
            string2 = string3;
        }
        resultsAnd3ButtonGroupDataBean.setLocation(string3);
        resultsAnd3ButtonGroupDataBean.setDescription(string2);
        resultsAnd3ButtonGroupDataBean.setText("");
        resultsAnd3ButtonGroupDataBean.setResults(string);
        return resultsAnd3ButtonGroupDataBean;
    }

    private boolean displayError(ResultsAnd3ButtonGroupDataBean resultsAnd3ButtonGroupDataBean) {
        boolean bl = false;
        try {
            GenericGui genericGui = (GenericGui)this.userData.get("DISPLAY_HANDLE");
            resultsAnd3ButtonGroupDataBean = (ResultsAnd3ButtonGroupDataBean)genericGui.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", resultsAnd3ButtonGroupDataBean.getTemplateName(), (GenericGuiPanelBean)resultsAnd3ButtonGroupDataBean, this.userData);
            if (resultsAnd3ButtonGroupDataBean.isSecondRadioButtonSelected()) {
                bl = true;
            } else if (resultsAnd3ButtonGroupDataBean.isThirdRadioButtonSelected()) {
                try {
                    Context context = (Context)this.userData.get("STS_CONTEXT");
                    context.getVariable(SD.USER_SELECTION_VARIABLE).setValue(SD.DELAY);
                    context.getVariable(SD.OVERALL_STATUS_VARIABLE).setValue(SD.DELAY);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public void elementLevelDeactivate(String string) throws ServiceableElementMaintenanceException {
        string = this.overrideLocation(string);
        Trace.trace((String)TRACE_MASKT, (Object)("-> PIBpaConcurrentMaintenance.elementLevelDeactivate(" + string + ")"));
        PETrace.petrace((Map)this.userData, (String)("deactivating location: " + string));
        try {
            boolean bl;
            do {
                bl = false;
                this.showBusy(new LocalizableText("FRU level deactivation for location: " + string));
                Object var3_4 = null;
                try {
                    Hashtable hashtable = this.cimClient_.bpaFruLevelDeactivate(string);
                    if (hashtable == null) continue;
                    Integer n = (Integer)hashtable.get("ReturnCode");
                    Integer n2 = (Integer)hashtable.get("ErrorData");
                    Trace.trace((String)TRACE_MASKT, (Object)("PIBpaConcurrentMaintenance.elementLevelDeactivate returnCode=" + n + ", errorData=" + n2));
                    if (n != null) {
                        int n3 = n;
                        if (n3 == 0) continue;
                        PETrace.petrace((Map)this.userData, (String)("BPA elementLevelDeactivate failed with rc=" + n3));
                        bl = this.displayOtherFailure("BPA elementLevelDeactivate failed with rc=" + n3);
                        continue;
                    }
                    PETrace.petrace((Map)this.userData, (String)"BPA elementLevelDeactivate did not return any rc???  Continuing...");
                }
                catch (Exception exception) {
                    PETrace.petrace((Map)this.userData, (String)("Exception caught from BPA elementLevelDeactivate: " + exception));
                    PETrace.petrace((Map)this.userData, (Throwable)exception);
                    bl = this.displayLockFailure("Exception caught from BPA elementLevelDeactivate: " + exception);
                }
            } while (bl);
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKT, (Object)("<-! PIBpaConcurrentMaintenance.elementLevelDeactivate Exception caught: " + exception));
            Trace.trace((String)TRACE_MASKT, (Object)exception);
            if (exception instanceof ServiceableElementMaintenanceException) {
                throw (ServiceableElementMaintenanceException)((Object)exception);
            }
            throw new ServiceableElementMaintenanceException((Throwable)exception);
        }
        finally {
            this.destroyBusy();
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- PIBpaConcurrentMaintenance.elementLevelDeactivate(" + string + ")"));
    }

    public String getServiceEffect(String string) throws ServiceableElementMaintenanceException {
        string = this.overrideLocation(string);
        Trace.trace((String)TRACE_MASKT, (Object)("-> PIBpaConcurrentMaintenance.getServiceEffect(" + string + ")"));
        String string2 = "UNKNOWN";
        try {
            this.showBusy(new LocalizableText("Querying service effect for location: " + string));
            Hashtable hashtable = this.cimClient_.bpaDisplayServiceEffect(string);
            if (hashtable != null) {
                Integer n = (Integer)hashtable.get("ReturnCode");
                Integer n2 = (Integer)hashtable.get("ErrorData");
                Trace.trace((String)TRACE_MASKT, (Object)("PIBpaConcurrentMaintenance.getServiceEffect returnCode=" + n + ", errorData=" + n2));
                if (n != null) {
                    string2 = n == 0 ? "REDUNDANT" : "NOT_REDUNDANT";
                }
            }
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKT, (Object)("<-! PIBpaConcurrentMaintenance.getServiceEffect Exception caught: " + exception));
            Trace.trace((String)TRACE_MASKT, (Object)exception);
            throw new ServiceableElementMaintenanceException((Throwable)exception);
        }
        finally {
            this.destroyBusy();
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- PIBpaConcurrentMaintenance.getServiceEffect concurrency status: " + string2));
        return string2;
    }

    public void systemLevelDeactivate(String string) throws ServiceableElementMaintenanceException {
        Trace.trace((String)TRACE_MASKT, (Object)("<> PIBpaConcurrentMaintenance.systemLevelDeactivate(" + string + ") - NOOP"));
    }

    public void setServiceLock(String string) throws ServiceableElementMaintenanceException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> PIBpaConcurrentMaintenance.setServiceLock");
        PETrace.petrace((Map)this.userData, (String)"setting service lock");
        this.lockMayHaveBeenObtained = true;
        try {
            boolean bl;
            do {
                bl = false;
                this.showBusy(new LocalizableText("Setting BPA service lock"));
                Object var3_4 = null;
                try {
                    Hashtable hashtable = this.cimClient_.bpaLockAction(SET_LOCK);
                    if (hashtable == null) continue;
                    Integer n = (Integer)hashtable.get("ReturnCode");
                    Integer n2 = (Integer)hashtable.get("ErrorData");
                    Trace.trace((String)TRACE_MASKT, (Object)("PIBpaConcurrentMaintenance.setServiceLock returnCode=" + n + ", errorData=" + n2));
                    if (n != null) {
                        int n3 = n;
                        if (n3 == 0) continue;
                        PETrace.petrace((Map)this.userData, (String)("BPA lock attempt failed with rc=" + n3));
                        if (n3 == 38) {
                            bl = this.displayLockFailure("The BPA service lock is currently held by another HMC");
                            continue;
                        }
                        bl = this.displayLockFailure("The BPA service lock could not be obtained");
                        continue;
                    }
                    PETrace.petrace((Map)this.userData, (String)"BPA lock attempt failed; no rc returned???");
                    bl = this.displayLockFailure("The BPA service lock could not be obtained");
                }
                catch (Exception exception) {
                    PETrace.petrace((Map)this.userData, (String)("Exception caught trying to obtain BPA lock: " + exception));
                    PETrace.petrace((Map)this.userData, (Throwable)exception);
                    bl = this.displayLockFailure("Exception caught trying to obtain BPA lock: " + exception);
                }
            } while (bl);
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKT, (Object)("<-! PIBpaConcurrentMaintenance.setServiceLock Exception caught: " + exception));
            Trace.trace((String)TRACE_MASKT, (Object)exception);
            if (exception instanceof ServiceableElementMaintenanceException) {
                throw (ServiceableElementMaintenanceException)((Object)exception);
            }
            throw new ServiceableElementMaintenanceException((Throwable)exception);
        }
        finally {
            this.destroyBusy();
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- PIBpaConcurrentMaintenance.setServiceLock");
    }

    public void resetServiceLock(String string) throws ServiceableElementMaintenanceException {
        Trace.trace((String)TRACE_MASKT, (Object)("-> PIBpaConcurrentMaintenance.resetServiceLock(" + string + ")"));
        PETrace.petrace((Map)this.userData, (String)"resetting BPA service lock");
        try {
            boolean bl;
            do {
                bl = false;
                this.showBusy(new LocalizableText("Resetting BPA service lock"));
                Object var3_4 = null;
                try {
                    String string2 = (String)this.userData.get("rvType");
                    Hashtable hashtable = string2 != null ? (string2.equals("RESET_SERVICE_LOCK") ? this.cimClient_.bpaLockAction(RESET_LOCK) : this.cimClient_.bpaLockAction(CLEAR_LOCK)) : this.cimClient_.bpaLockAction(CLEAR_LOCK);
                    if (hashtable == null) continue;
                    Integer n = (Integer)hashtable.get("ReturnCode");
                    Integer n2 = (Integer)hashtable.get("ErrorData");
                    Trace.trace((String)TRACE_MASKT, (Object)("PIBpaConcurrentMaintenance.resetServiceLock returnCode=" + n + ", errorData=" + n2));
                    if (n != null) {
                        int n3 = n;
                        if (n3 != 0) {
                            PETrace.petrace((Map)this.userData, (String)("Resetting BPA service lock failed with rc=" + n3));
                            continue;
                        }
                        this.lockMayHaveBeenObtained = false;
                        continue;
                    }
                    PETrace.petrace((Map)this.userData, (String)"BPA resetServiceLock did not return any rc???  Continuing...");
                }
                catch (Exception exception) {
                    PETrace.petrace((Map)this.userData, (String)("Exception caught from BPA resetServiceLock: " + exception));
                    PETrace.petrace((Map)this.userData, (Throwable)exception);
                }
            } while (bl);
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKT, (Object)("<-! PIBpaConcurrentMaintenance.resetServiceLock Exception caught: " + exception));
            Trace.trace((String)TRACE_MASKT, (Object)exception);
            if (exception instanceof ServiceableElementMaintenanceException) {
                throw (ServiceableElementMaintenanceException)((Object)exception);
            }
            throw new ServiceableElementMaintenanceException((Throwable)exception);
        }
        finally {
            this.destroyBusy();
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- PIBpaConcurrentMaintenance.resetServiceLock(" + string + ")"));
    }

    public void systemLevelActivate(String string) throws ServiceableElementMaintenanceException {
        Trace.trace((String)TRACE_MASKT, (Object)("<> PIBpaConcurrentMaintenance.systemLevelActivate(" + string + ") - NOOP"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void identify(String string, int n) throws ServiceableElementMaintenanceException {
        string = this.overrideLocation(string);
        Trace.trace((String)TRACE_MASKT, (Object)("-> PIBpaConcurrentMaintenance.identify(" + string + "," + n + ")"));
        if (this.serviceableElement != null && !(this.serviceableElement instanceof BpaResidentFru)) {
            try {
                if (n == 1) {
                    this.showBusy(new LocalizableText("Turning on LED at location: " + string));
                } else {
                    this.showBusy(new LocalizableText("Turning off LED at location: " + string));
                }
                this.cimClient_.setIdentifyLEDs(new String[]{string}, new Integer[]{new Integer(n)}, new Integer[]{new Integer(2)});
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKT, (Object)"!!!PIBpaConcurrentMaintenance.identify exception caught - ignorning");
                Trace.trace((String)TRACE_MASKT, (Object)exception);
            }
            finally {
                this.destroyBusy();
            }
        } else {
            Trace.trace((String)TRACE_MASKT, (Object)"PIBpaConcurrentMaintenance.identify bypassing identify for BPA resident fru");
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- PIBpaConcurrentMaintenance.identify");
    }

    public void elementLevelActivate(String string) throws ServiceableElementMaintenanceException {
        string = this.overrideLocation(string);
        Trace.trace((String)TRACE_MASKT, (Object)("-> PIBpaConcurrentMaintenance.elementLevelActivate(" + string + ")"));
        PETrace.petrace((Map)this.userData, (String)("activating location: " + string));
        this.showBusy(new LocalizableText("Waiting 5 minutes for communication to be established."));
        try {
            Thread.sleep(300000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.destroyBusy();
        try {
            boolean bl;
            do {
                bl = false;
                this.showBusy(new LocalizableText("FRU level activate for location: " + string));
                Object var3_5 = null;
                try {
                    Hashtable hashtable = this.cimClient_.bpaFruLevelActivate(string);
                    if (hashtable == null) continue;
                    Integer n = (Integer)hashtable.get("ReturnCode");
                    Integer n2 = (Integer)hashtable.get("ErrorData");
                    Trace.trace((String)TRACE_MASKT, (Object)("PIBpaConcurrentMaintenance.elementLevelActivate returnCode=" + n + ", errorData=" + n2));
                    if (n != null) {
                        int n3 = n;
                        if (n3 != 0) {
                            PETrace.petrace((Map)this.userData, (String)("BPA elementLevelActivate failed with rc=" + n3));
                            bl = this.displayOtherFailure("BPA elementLevelActivate failed with rc=" + n3);
                            continue;
                        }
                        this.showBusy(new LocalizableText("Waiting 5 minutes for activation to complete."));
                        try {
                            Thread.sleep(300000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.destroyBusy();
                        continue;
                    }
                    PETrace.petrace((Map)this.userData, (String)"BPA elementLevelActivate did not return any rc???  Continuing...");
                }
                catch (Exception exception) {
                    PETrace.petrace((Map)this.userData, (String)("Exception caught from BPA elementLevelActivate: " + exception));
                    PETrace.petrace((Map)this.userData, (Throwable)exception);
                    bl = this.displayLockFailure("Exception caught from BPA elementLevelActivate: " + exception);
                }
            } while (bl);
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKT, (Object)("<-! PIBpaConcurrentMaintenance.elementLevelActivate Exception caught: " + exception));
            Trace.trace((String)TRACE_MASKT, (Object)exception);
            if (exception instanceof ServiceableElementMaintenanceException) {
                throw (ServiceableElementMaintenanceException)((Object)exception);
            }
            throw new ServiceableElementMaintenanceException((Throwable)exception);
        }
        finally {
            this.destroyBusy();
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- PIBpaConcurrentMaintenance.elementLevelActivate(" + string + ")"));
    }

    protected void showBusy(LocalizableText localizableText) {
        try {
            GenericGui genericGui = (GenericGui)this.userData.get("DISPLAY_HANDLE");
            genericGui.showBusyDialog(new LocalizableText("Hardware operation in progress..."), localizableText, this.userData);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void destroyBusy() {
        try {
            GenericGui genericGui = (GenericGui)this.userData.get("DISPLAY_HANDLE");
            genericGui.destroyBusyDialog(this.userData);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String overrideLocation(String string) {
        String string2;
        Map map;
        String string3 = string;
        if (this.serviceableElement != null && (map = this.serviceableElement.getProperties()) != null && (string2 = (String)map.get("COMMAND_TARGET")) != null) {
            int n = string.indexOf("-");
            if (n != -1) {
                string3 = string.substring(0, n);
            }
            string3 = string3 + "-" + string2;
            Trace.trace((String)TRACE_MASKT, (Object)("PIBpaConcurrentMaintenance.overrideLocation source=" + string + ", target=" + string3));
        }
        return string3;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.lockMayHaveBeenObtained) {
                this.lockMayHaveBeenObtained = false;
                PETrace.petrace((Map)this.userData, (String)"in finalize, unconditionally freeing BPA lock");
                String string = (String)this.userData.get("rvType");
                if (string != null && !string.equals("SET_SERVICE_LOCK")) {
                    this.resetServiceLock((String)this.serviceableElement.getProperty((Object)"LOCATION"));
                }
            }
        }
        catch (Exception exception) {
            PETrace.petrace((Map)this.userData, (String)("in finalize, exception freeing BPA lock - ignorning: " + exception));
            PETrace.petrace((Map)this.userData, (Throwable)exception);
        }
    }
}

